//+------------------------------------------------------------------+ 
//|                                               T3 Bands clean.mq4 | 
//+------------------------------------------------------------------+ 
#property indicator_separate_window 
#property indicator_buffers 5 
#property indicator_color1 Green 
#property indicator_color2 Red 
#property indicator_color3 Blue 
#property indicator_color4 Yellow 
#property indicator_color5 Silver 
//----
extern int MA_Period_1 = 5; 
extern int MA_Period_2 = 15; 
extern int MA_Period_3 = 20; 
extern int MA_Period_4 = 35; 
extern int MA_Period_5 = 80; 
extern double b = 0.86; 

//
//
//
//
//

double MapBuffer1[]; 
double MapBuffer2[]; 
double MapBuffer3[]; 
double MapBuffer4[]; 
double MapBuffer5[]; 

//+------------------------------------------------------------------+ 
//|                                                                  | 
//+------------------------------------------------------------------+ 

int init() 
{ 
      IndicatorDigits(MarketInfo(Symbol(), MODE_DIGITS)); 
      IndicatorShortName("T3 Bands"); 
      SetIndexBuffer(0, MapBuffer1); 
      SetIndexBuffer(1, MapBuffer2); 
      SetIndexBuffer(2, MapBuffer3); 
      SetIndexBuffer(3, MapBuffer4); 
      SetIndexBuffer(4, MapBuffer5); 
      SetIndexLabel(0,"T3 "+MA_Period_1);
      SetIndexLabel(1,"T3 "+MA_Period_2);
      SetIndexLabel(2,"T3 "+MA_Period_3);
      SetIndexLabel(3,"T3 "+MA_Period_4);
      SetIndexLabel(4,"T3 "+MA_Period_5);
   return(0); 
} 

//+------------------------------------------------------------------+ 
//|                                                                  | 
//+------------------------------------------------------------------+ 

int start() 
{ 
   int limit, i; 
   int counted_bars = IndicatorCounted(); 

   if(counted_bars < 0) return(-1); 
   if(counted_bars > 0) counted_bars--; 
      limit = Bars - counted_bars; 

   for(i = limit; i >= 0; i--) 
     { 
         MapBuffer1[i] = iCustom(NULL,0,"T3 Clean",MA_Period_1,b,0,i);
         MapBuffer2[i] = iCustom(NULL,0,"T3 Clean",MA_Period_2,b,0,i);
         MapBuffer3[i] = iCustom(NULL,0,"T3 Clean",MA_Period_3,b,0,i);
         MapBuffer4[i] = iCustom(NULL,0,"T3 Clean",MA_Period_4,b,0,i);
         MapBuffer5[i] = iCustom(NULL,0,"T3 Clean",MA_Period_5,b,0,i);
     } 
   return(0); 
} 
//+------------------------------------------------------------------+

